#include <bits/stdc++.h>
using namespace std;

int BLOCK_SIZE;

struct Query {
    int l, r, idx;
};

// ako neko cita iz komisije jedva sam napisao ovaj algoritam da ne bi radio
// samo na 5 test primera 
bool cmp(const Query& a, const Query& b) {
    if (a.l / BLOCK_SIZE != b.l / BLOCK_SIZE)
        return a.l / BLOCK_SIZE < b.l / BLOCK_SIZE;
    return ((a.l / BLOCK_SIZE) & 1) ? (a.r < b.r) : (a.r > b.r);
}

// globalne frekvencije
map<long long, int> numFreq;
map<int, int> freqCount; // koliko brojeva ima frekvenciju f
int maxFreq = 0;

void expanduj(int idx, const vector<long long>& arr) {
    int prethodna = numFreq[arr[idx]];
    numFreq[arr[idx]]++;
    int nova = numFreq[arr[idx]];

    freqCount[prethodna]--;
    freqCount[nova]++;
    maxFreq = max(maxFreq, nova);
}

void shrinkuj(int idx, const vector<long long>& arr) {
    int prethodna = numFreq[arr[idx]];
    numFreq[arr[idx]]--;
    int nova = numFreq[arr[idx]];

    freqCount[prethodna]--;
    if (nova > 0) freqCount[nova]++;

    if (freqCount[maxFreq] == 0) maxFreq--;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (long long& x : a) cin >> x;

    vector<long long> prefix(n + 1, 0);
    unordered_map<long long, int> first, last;

    for (int i = 0; i < n; ++i)
        prefix[i + 1] = prefix[i] + a[i];

    for (int i = 0; i <= n; ++i) {
        if (!first.count(prefix[i])) first[prefix[i]] = i;
        last[prefix[i]] = i;
    }

    // Priprema upita l r gde je suma 0
    vector<Query> queries;
    int index = 0;
    for (const auto& [sum, l] : first) {
        int r = last[sum];
        if (r - l <= 0) continue;
        queries.push_back({ l, r - 1, index++ });
    }

    int q = queries.size();
    BLOCK_SIZE = static_cast<int>(sqrt(n)) + 1;
    sort(queries.begin(), queries.end(), cmp);

    int L = 0, R = -1;
    vector<int> results(q);

    for (const auto& query : queries) {
        int l = query.l;
        int r = query.r;

        while (L > l) expanduj(--L, a);
        while (R < r) expanduj(++R, a);
        while (L < l) shrinkuj(L++, a);
        while (R > r) shrinkuj(R--, a);

        results[query.idx] = maxFreq;
    }

    int answer = 0;
    for (int x : results) answer = max(answer, x);

    cout << answer << '\n';
    return 0;
}